#include <iostream>
#include <cstdio>
#include <vector>
#include <queue>
#include <map>
#include <cassert>

using namespace std;

const int maxn = 1 << 17;
const int inf = 1e9;

struct Graph {
	struct Edge {
		int from, to, flow, cap;
		Edge() {}
		Edge(int from, int to, int cap) : from(from), to(to), flow(0), cap(cap) {}
	};

	int n;
	vector<Edge> edges;
	vector<vector<int> > e;
	vector<int> d, c;

	Graph() {}
	Graph(int n) {
		this->n = n;
		e.resize(n);
	}

	void addEdge(int from, int to, int cap, int cap2) {
		e[from].push_back(edges.size());
		edges.push_back(Edge(from, to, cap));
		e[to].push_back(edges.size());
		edges.push_back(Edge(to, from, cap2));
	}

	bool bfs(int v) {
		c.assign(n, 0);
		d.assign(n, inf);
		d[v] = 0;
		queue<int> q;
		q.push(0);
		while (!q.empty()) {
			int v = q.front();
			q.pop();
			for (int i = 0; i < (int)e[v].size(); i++) {
				Edge cur = edges[e[v][i]];
				if (cur.flow < cur.cap && d[cur.to] > d[v] + 1) {
					d[cur.to] = d[v] + 1;
					q.push(cur.to);
				}
			}
		}
		return d[n - 1] != inf;
	}
	
	int dfs(int v, int flow) {
		if (v == n - 1) return flow;
		if (flow == 0) return 0;
		for (int &i = c[v]; i < (int)e[v].size(); i++) {
			Edge cur = edges[e[v][i]];
			if (d[cur.to] != d[v] + 1) continue;
			int pushed = dfs(cur.to, min(flow, cur.cap - cur.flow));
			if (pushed) {
				edges[e[v][i]].flow += pushed;
				edges[e[v][i] ^ 1].flow -= pushed;
				return pushed;
			}
		}
		return 0;
	}

	int getFlow() {
		int flow = 0;
		while (bfs(0)) {
			while (int pushed = dfs(0, inf)) {
				flow += pushed;
			}
		}
		return flow;
	}

	int x, s, cr;
	vector<vector<pair<int, int> > > ans;

	void dfs2(int v) {
		if (v == n - 1) return;
		for (int i = 0; i < (int)e[v].size(); i++) {
			Edge cur = edges[e[v][i]];
			if (cur.flow > 0) {
				/*if (v != 0 && cur.to != n - 1) {
					int v1 = (v - 1) / (x + 1);
					int t1 = (v - 1) % (x + 1);
					int v2 = (cur.to - 1) / (x + 1);
					int t2 = (cur.to - 1) % (x + 1);
					if (v1 != v2 && t1 + 1 != t2) continue;
				}*/
				dfs2(cur.to);
				edges[e[v][i]].flow--;
				edges[e[v][i] ^ 1].flow++;
				if (v != 0 && cur.to != n - 1) {
					int v1 = (v - 1) / (x + 1);
					int t1 = (v - 1) % (x + 1);
					int v2 = (cur.to - 1) / (x + 1);
					int t2 = (cur.to - 1) % (x + 1);
					if (v1 != v2) {
						ans[t1].push_back(make_pair(cr, v2));
					}
				}
				return;
			}
		}
	}

	int go(int a, int b, int c) {
		return a ^ b ^ c;
	}

	void decompose(int flow) {
		ans.resize(x);
		for (cr = 0; cr < flow; cr++) {
			dfs2(0);
		}
		vector<int> pos(flow, s);

		for (int i = 0; i < x; i++) {
			map<pair<int, int>, vector<int> > mp;
			for (int j = 0; j < (int)ans[i].size(); j++) {
				int u = pos[ans[i][j].first];
				int v = ans[i][j].second;
				if (u > v) swap(u, v);
				mp[make_pair(u, v)].push_back(ans[i][j].first);
			}
			ans[i].clear();
			for (map<pair<int, int>, vector<int> > :: iterator it = mp.begin(); it != mp.end(); it++) {
				assert(it->second.size() <= 2);
				if (it->second.size() == 2) {
					int u = it->second[0];
					int v = it->second[1];
					for (int k = i + 1; k < x; k++) {
						for (int j = 0; j < (int)ans[k].size(); j++) {
							if (ans[k][j].first == u) ans[k][j].first = v;
							else if (ans[k][j].first == v) ans[k][j].first = u;
						}
					}
				} else {
					ans[i].push_back(make_pair(it->second[0], go(it->first.first, it->first.second, pos[it->second[0]])));
				}
			}
			cout << ans[i].size() << " ";
			for (int j = 0; j < (int)ans[i].size(); j++) {
				cout << ans[i][j].first + 1 << " " << ans[i][j].second + 1 << " \n"[j + 1 == (int)ans[i].size()];
				pos[ans[i][j].first] = ans[i][j].second;
			}
		}
	}
};

int n, m, k, s, t;
vector<int> u, v;

bool ok(int x, bool f) {
	Graph gr(n * (x + 1) + 2);
	for (int i = 0; i < m; i++) {
		for (int t = 0; t < x; t++) {
			gr.addEdge(1 + u[i] * (x + 1) + t, 1 + v[i] * (x + 1) + t + 1, 1, 0);
			gr.addEdge(1 + v[i] * (x + 1) + t, 1 + u[i] * (x + 1) + t + 1, 1, 0);
		}
	}
	for (int i = 0; i < n; i++) {
		for (int t = 0; t < x; t++) {
			gr.addEdge(1 + i * (x + 1) + t, 1 + i * (x + 1) + t + 1, inf, 0);
		}
	}
	gr.addEdge(0, 1 + s * (x + 1), k, 0);
	gr.addEdge(1 + t * (x + 1) + x, n * (x + 1) + 1, inf, 0);
	if (f) {
		gr.x = x;
		gr.s = s;
		gr.getFlow();
		gr.decompose(k);
		return 1;
	}
	return gr.getFlow() >= k;
}

int main() {
	//freopen("input.txt", "r", stdin);
	//freopen("output.txt", "w", stdout);

	cin >> n >> m >> k >> s >> t;
	--s; --t;
	u.resize(m);
	v.resize(m);
	for (int i = 0; i < m; i++) {
		cin >> u[i] >> v[i];
		--u[i];
		--v[i];
	}

	int l = 0, r = n + k;
	while (r - l > 1) {
		int x = (l + r) >> 1;
		if (ok(x, false)) {
			r = x;
		} else {
			l = x;
		}
	}
	cout << r << endl;
	ok(r, true);

	return 0;
}